; Starpath by HellMood/DSR
; 64 byte intro for MSDOS
; 1st place at "Lovebyte 2025"
;
; heaven is one step around the corner
; ... you just have to keep moving
;
; greetings to all sizecoders !
org 100h		; SI = IP = 0x100, AH = 0, BH = 0
mov al,0x13		; mode 13h, 320x200 pixels, 256 colors
leave			; = 0xC9 = MIDI Change Drumkit, no harm done otherwise (BP,SP)
db 56			; = 0x56 = SFX Drumkit, "CMP" on first run
Y: mov dx,330h	; port for MIDI output, expects UART mode already set
outsb			; SI++, play MIDI from code, also advance frame
X: cwd			; clear DX for pixel setting, also = 0x99 = play drum note
push cx			; = 51h = MIDI WIND SFX (push/pop not actually used)
pop di			; = VOLUME and the largest value below 127 that realigns stack
mov bl,14		; start depth at 14, also constant for dither effect
int 0x10		; set mode on first run, set pixel on further runs
add cx,bx		; advance pixel location by dither constant above
L: inc bx		; pixel loop: increment depth by one
mov ax,0xcccc	; Modified Rrrola constant (0xCCCD) to fix "loop" offset
mul cx			; Getting X,Y in DL,DH
mov al,dh		; getting Y into AL
mul bl			; multiply Y by current depth (into AH)
xchg ax,dx		; store Y' into DH, get X into AL
sub al,bl		; curve X by the current depth
jc W			; if left of the curve, jump to "sky"
mul bl			; multiply X by current depth (into AH)
mov al,dh		; get Y' in AL (now AL,AH = Y',X')
or al,ah		; OR for geometry and texture pattern
lea dx,[bx+si]	; get (current depth) + (current frame count) in DX (DL)
and al,dl		; mask geometry/texture by time shifted depth...
test al,16		; ... to create "gaps"
jz L			; if ray did not hit, repeat pixel loop
jmp short Q		; jump over the sky ^^
W: mov al,27	; is both the star color and palette offset into sky
cmp dl,cl		; pseudorandom multiplication leftover DL compared
jz Q			; to shifted depth, 1 in 256 chance to be a star *
shld ax,cx,4	; if not, shift the starcolor and add scaled pixel count
Q: mov ah,0xc	; AH = 0x0C, setting pixel above with int 10h
loop X			; pixelcount--, repeat
jmp short Y		; frame complete, jump above to play MIDI and advance frame
